#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Glass CandyMod01.fsh  by leon   
//https://www.shadertoy.com/view/sljBRG
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Glass Candy by Leon Denise 2022/05/13
// Using code from Inigo Quilez, Antoine Zanuttini and many more

// A classic kaleidoscopic iterated function with spheres
// I was playing with reflections and inversed the ray and normal for curiosity
// It gave a funky fake refraction that was fun to play with

const float falloff = 1.2;
const float size = .5;
const float range = 1.1;

float colorOffset;

mat2 rot (float a) { return mat2(cos(a),-sin(a),sin(a),cos(a)); }

// signed distance function
float map(vec3 p)
{
    float d = 100.;
    float s = 100.;
    float a = 1.;
    float t = 196.+iTime * .1;
    for (float i = 0.; i < 12.; ++i)
    {
        p.x = abs(p.x)-range*a;
        p.xz *= rot(t/a);
        p.yx *= rot(t/a);
        s = length(p)-size*a;
        colorOffset = s < d ? i : colorOffset;
        d = min(d, s);
        a /= falloff;
    }
    
    return d;
}

// Antoine Zanuttini
// https://www.shadertoy.com/view/3sBGzV
vec3 getNormal (vec3 pos)
{
    vec2 noff = vec2(0.001,0);
    return normalize(map(pos)-vec3(map(pos-noff.xyy), map(pos-noff.yxy), map(pos-noff.yyx)));
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    // coordinates
    vec2 uv = (fragCoord.xy - iResolution.xy / 2.)/iResolution.y;
    vec3 noise = texture2D(texture0, fragCoord.xy/1024.).rgb;
    vec3 ray = normalize(vec3(uv, 1));
    vec3 pos = vec3(0,0,-3);
    
    // init variables
    vec3 color, normal, tint;
    float index, shade, light;
    const float count = 25.;
    colorOffset = 0.;

    // ray marching
    for (index = count; index > 0.; --index)
    {
        float dist = map(pos);
        if (dist < .001) break;
        dist *= .9+.1*noise.z;
        pos += ray*dist;
    }
    
    // lighting
    shade = index/count;
    normal = getNormal(pos);
    light = pow(dot(reflect(ray, normal), vec3(0,1,0))*.5+.5, 4.);
    light += pow(dot(normal, ray)*.5+.5, .5);
    color = vec3(.5) * shade * light;
    
    // ray bouncing (where the funky stuff happens)
    ray = reflect(normal, ray); // should be ray = reflect(ray, normal);
    pos += ray * (.2+.19*sin(iTime*2.+length(uv)*6.)); // jumpy bounce
    for (index = count; index > 0.; --index)
    {
        float dist = map(pos);
        if (dist < .001) break;
        dist *= .9+.1*noise.z;
        pos += ray*dist;
    }

    // coloring
    normal = getNormal(pos);
    light = pow(dot(normal, ray)*.5+.5, 1.);
    tint = .5+.5*cos(vec3(0,.3,.6)*6.+colorOffset*2.+pos.y*2.+light);
    color += tint * shade * index/count * (noise.r*.3+.7);

    fragColor = vec4(color, 1.);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

